    <div class="viewReleases-main-sec">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Track Title</th>
                    <th>Artist</th>
                    <th>Upload Track</th>
            </thead>
            <tbody>

                <?php $__currentLoopData = $tracks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $track): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="track-title"><span><?php echo e($track->title ?? ''); ?></span></td>
                    <td>
                        <?php
                        $artist = getArtistById($track->artists);
                        $artistName = null;
                        if(!empty($artist)) {
                        $artistName = $artist->name;
                        }
                        ?>

                        <?php echo e($artistName); ?>

                    </td>

                    <td class="audio-btn-td">
                        <?php
                        $trackFiles = [];
                        if(!empty($track->audio_files)){
                        $trackFiles = json_decode($track->audio_files);
                        }
                        ?>
                        <?php $__currentLoopData = $trackFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trackFile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!empty($trackFile)): ?>
                        <audio controls class="mt-1">
                            <source src="<?php echo e(asset(Illuminate\Support\Facades\Storage::url($trackFile))); ?>" type="audio/ogg">
                            <source src="<?php echo e(asset(Illuminate\Support\Facades\Storage::url($trackFile))); ?>" type="audio/mpeg">
                            Your browser does not support the audio element.
                        </audio>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </td>
                    <td class="add-track-button">
                        <button data-track="<?php echo e($track->id); ?>" data-release="<?php echo e($release->id); ?>" class="btn edit" id="editAlbumReleaseTrack">Edit</button>

                        <form method="POST" action="<?php echo e(route('release.track.delete')); ?>" style="display:inline">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="track_id" value="<?php echo e($track->id); ?>">
                            <input type="hidden" name="release_id" value="<?php echo e($release->id); ?>">

                            <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn delete">
                                <i class="fa-solid fa-trash"></i> Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo $tracks->links('pagination::bootstrap-5'); ?>

    </div>

    <div class="modal fade add-single-track" id="editReleaseTrackModals" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Update Track</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
            </div>

            <div id="editTrackModalsData">
            </div>




        </div>
    </div>
</div>

    <script>
        $(document).on('click', '#editAlbumReleaseTrack', function() {
            var track_id = $(this).data('track');
            var release_id = $(this).data('release');

            $.ajax({
                url: "<?php echo e(route('release.track.edit')); ?>",
                type: "POST",
                data: {
                    'track_id': track_id,
                    'release_id': release_id,
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(response) {
                    if (response.error) {
                    alert(response.error);
                    } else {
                        $('#editTrackModalsData').html(response.html);
                        $('#editReleaseTrackModals').modal('show');
                    }
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                }
            });

        });
    </script>



































    <?php /**PATH /home/devwhmcs/public_html/resources/views/releases/tracks.blade.php ENDPATH**/ ?>